require('dotenv').config();

const DEFAULT_PRICE_UPDATE_TIME = '09:00';
const DEFAULT_PRICE_UPDATE_TIMEZONE = 'Africa/Johannesburg';

const DEFAULT_PRICE_UPDATE_CRON = (() => {
  const [hours, minutes] = DEFAULT_PRICE_UPDATE_TIME.split(':');
  const hour = Number.parseInt(hours, 10);
  const minute = Number.parseInt(minutes, 10);
  return `${minute} ${hour} * * *`;
})();

const buildCronExpression = (time) => {
  const [hours, minutes] = time.split(':');
  const hour = Number.parseInt(hours, 10);
  const minute = Number.parseInt(minutes, 10);

  if (
    Number.isNaN(hour)
    || Number.isNaN(minute)
    || hour < 0
    || hour > 23
    || minute < 0
    || minute > 59
  ) {
    console.warn(`Invalid PRICE_UPDATE_TIME "${time}" supplied. Falling back to ${DEFAULT_PRICE_UPDATE_TIME}.`);
    return DEFAULT_PRICE_UPDATE_CRON;
  }

  return `${minute} ${hour} * * *`;
};

const getPriceUpdateConfig = () => ({
  time: process.env.PRICE_UPDATE_TIME || DEFAULT_PRICE_UPDATE_TIME,
  timezone: process.env.PRICE_UPDATE_TIMEZONE || DEFAULT_PRICE_UPDATE_TIMEZONE,
});

module.exports = {
  DEFAULT_PRICE_UPDATE_TIME,
  DEFAULT_PRICE_UPDATE_TIMEZONE,
  DEFAULT_PRICE_UPDATE_CRON,
  buildCronExpression,
  getPriceUpdateConfig,
};
